﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RevisionAnalyser.Global;
using RecoderProject;
using System.IO;
using RevisionAnalyser.Controls;

namespace RevisionAnalyser.Projects.RecoderProject.Tasks
{
    public class SynchronizeTask : RecoderTask
    {
        private RecoderProject _project = (RecoderProject)CurrentProject.Instance.Project;

        public SynchronizeTask()
        {
        }

        public override void Run()
        {
            try
            {
                _project.SynchronizeSvnRevisions();
                _project.RevisionSet.Update();
                if (_project.RevisionSet.RevisionCount > 0)
                {
                    CreateSolidSXDatabase();
                }
                else
                {
                    RemoveFiles();
                }

                AddLog("Synchronized SVN revisions", Constants.COLOR_GREEN);
            }
            catch (Exception ex)
            {
                AddLog("Error: " + ex.Message, Constants.COLOR_RED);
            }
            finally
            {
                TaskFinished();
            }
        }

        private void CreateSolidSXDatabase()
        {
            RecoderAnalyser analyser = GetRecoderAnalyser(_project);
            EnableSubProgressBar(true);
            analyser.CreateSolidSXDatabase(String.Format("{0}\\Dataset.bin", _project.GetAnalysedFolder()), String.Format("{0}\\SolidSX2.db", _project.GetAnalysedFolder()));
            EnableSubProgressBar(false);
            //_project.OpenSolidSXFile(GetTaskForm(), String.Format("{0}\\SolidSX2.db", _project.GetAnalysedFolder()));
            GetTaskForm().UpdateSolidSX(String.Format("{0}\\SolidSX2.db", _project.GetAnalysedFolder()));
        }

        private void RemoveFiles()
        {
            AddLog("No revisions, deleting files", Constants.COLOR_GREEN);
            File.Delete(String.Format("{0}\\Dataset.bin", _project.GetAnalysedFolder()));
            File.Delete(String.Format("{0}\\SolidSX2.db", _project.GetAnalysedFolder()));
            GetTaskForm().UpdateSolidSX(Constants.EMPTY_DB_PATH);
            //_project.OpenSolidSXFile(GetTaskForm(), Constants.EMPTY_DB_PATH);
        }
    }
}
